from math import *

class Shape():
    name    = 'Γενικό σχήμα, υπερκλάση'
    color   = 'white'       # default value
    bcolor  = 'black'       # border color default value

    def print_name(self):
        print(self.name)

    def change_color(self,newcolor):
        self.color=newcolor

    def emvado(self):
        return None

    def perimetros(self):
        return None

    def sxediase(self):
        return None


class parallilogrammo(Shape):
    name    = 'Παραλληλόγραμμο'
    width   = 0        # default values
    height  = 0
    x    = 0
    y    = 0

    def __init__(self, posx,posy,platos,ypsos):
        self.x      = posx
        self.y      = posy
        self.height = ypsos
        self.width  = platos

    def emvado(self):
        return self.width * self.height

    def perimetros(self):
        return 2*(self.width + self.height)

    def sxediase(self):
         return ('<rect x="{0}" y="{1}" width="{2}" height="{3}" fill="{4}" stroke-width="4" stroke="{5}" />\n'.format(str(self.x),str(self.y),str(self.width),str(self.height),self.color,self.bcolor))

class Triangle(Shape):
    name    = "Τρίγωνο"
    p1x     = 0
    p1y     = 0
    p2x     = 0
    p2y     = 0
    p3x     = 0
    p3y     = 0

    def __init__(self, x1,y1,x2,y2,x3,y3):
        self.p1x    = x1
        self.p1y    = y1
        self.p2x    = x2
        self.p2y    = y2
        self.p3x    = x3
        self.p3y    = y3

    def perimetros(self):
        ab=sqrt((self.p2x-self.p1x)**2+(self.p2y-self.p1y)**2)
        bg=sqrt((self.p2x-self.p3x)**2+(self.p2y-self.p3y)**2)
        ag=sqrt((self.p3x-self.p1x)**2+(self.p3y-self.p1y)**2)
        return(ab+ag+bg)

    def emvado(self):
        ab=sqrt((self.p2x-self.p1x)**2+(self.p2y-self.p1y)**2)
        gd=abs((self.p2x-self.p1x)*(self.p3y-self.p1y)-(self.p2y-self.p1y)*(self.p3x-self.p1x))/sqrt((self.p2x-self.p1x)**2+(self.p2y-self.p1y)**2)
        return 0.5 * ab*gd

    def sxediase(self):
         return ('<polygon points="{0},{1} {2},{3} {4},{5}" style="fill:{6};stroke-width:4;stroke:{7}"/>\n'.format(str(self.p1x),str(self.p1y),str(self.p2x),str(self.p2y),str(self.p3x),str(self.p3y),self.color,self.bcolor))


class kyklos(Shape):
    name    = 'Κύκλος'
    cx      = 0
    cy      = 0
    r       = 0

    def __init__(self, x,y,aktina):
        self.cx     = x
        self.cy     = y
        self.r      = aktina

    def emvado(self):
        return pi * self.r**2

    def perimetros(self):
        return 2*pi*self.r

    def sxediase(self):
         return ('<circle cx="{0}" cy="{1}" r="{2}" fill="{3}" stroke-width="4" stroke="{4}" />\n'.format(str(self.cx),str(self.cy),str(self.r),self.color,self.bcolor))

# παράθυρο 0,0 πάνω αριστερά κορυφή
# parallilogrammo (συντεταγμένες χ,ψ πάνω αριστερής κορυφής χ,ψ,πλάτος,ύψος)
a=parallilogrammo(150,100,200,200)
a.change_color("yellow")
d=parallilogrammo(225,200,50,95)
d.change_color("brown")
b=kyklos(75,60,50)
b.change_color("orange")
c=Triangle(150,95,250,19,350,95)
c.change_color("lime")

f= open("C:/Users/jsirris/Desktop/python_drawing.svg","w+")
f.write('<?xml version="1.0" encoding="UTF-8" ?>\n')
f.write('<svg width="600" height="600" viewBox="0 0 600 600" xmlns="http://www.w3.org/2000/svg">\n')
f.write(a.sxediase())
f.write(c.sxediase())
f.write(b.sxediase())
f.write(d.sxediase())
f.write('</svg>')
f.close()

print ('Εμβαδό σχημάτων')
print(a.name, a.emvado(), b.name, b.emvado(), c.name, c.emvado(), d.name, d.emvado())

print('Περίμετρος σχημάτων')
print(a.name, a.perimetros(),b.name, b.perimetros(),c.name, c.perimetros(),d.name, d.perimetros())